/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminDataObjForWFGroups;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminItemInList;
import filenet.vw.toolkit.admin.result.VWAdminLockWork;
import filenet.vw.toolkit.admin.result.VWAdminManageWflGroupsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWflGroupDataObj;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

public class VWAdminManageWflGroups {
    private Vector m_vSelectedWork = new Vector();
    private Vector m_vWflGroups = new Vector();
    private Vector m_vErrors = new Vector();
    private Vector m_wobsList = new Vector();
    private ListSelectionModel m_listSelectionModel = null;
    private VWTable m_resultsTable;
    private VWAdminResultTableModelBase m_tableModel;
    private VWAdminManageWflGroupsDialog m_manageWflGroupsDlg = null;

    public VWAdminManageWflGroups(VWAdminResultPane resultsPane) {
        this.m_tableModel = resultsPane.getTableModel();
        this.m_resultsTable = resultsPane.getResultsTable();
        this.m_listSelectionModel = this.m_resultsTable.getSelectionModel();
        if (this.m_resultsTable.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_noRowSelected, VWResource.s_manageWflGroupsTitle, 1, null);
            return;
        }
        VWAdminLockWork lockWork = new VWAdminLockWork(resultsPane, VWResource.s_manageWflGroupsTitle, VWResource.s_askManageWflGroups, VWResource.s_override);
        boolean b_cancel = lockWork.getReturnStatus();
        if (b_cancel) {
            this.removeReferences();
            return;
        }
        this.m_wobsList = lockWork.getWorkItemsList();
        this.initialize();
        if (!this.isAnyWflGroupDefined()) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_noWflGroupDefined, VWResource.s_manageWflGroupsTitle, 1, null);
            this.removeReferences();
            return;
        }
        this.m_manageWflGroupsDlg = new VWAdminManageWflGroupsDialog(this.m_vSelectedWork, resultsPane);
        this.m_manageWflGroupsDlg.setVisible(true);
        b_cancel = this.m_manageWflGroupsDlg.getStatus();
        if (b_cancel) {
            this.removeReferences();
            return;
        }
        this.m_vWflGroups = this.m_manageWflGroupsDlg.getWflGroupsDataObjects();
        this.updateWork();
        this.m_tableModel.refreshSelectedRows(this.m_resultsTable.getSelectedRows());
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog errDlg = new VWAdminErrorsDialog(resultsPane.getParentFrame(), VWResource.s_manageWflGroupsTitle, VWResource.s_manageWflGroupsErr, this.m_vErrors);
            errDlg.setVisible(true);
        }
        this.removeReferences();
    }

    private void initialize() {
        if (this.m_vSelectedWork != null) {
            this.m_vSelectedWork.removeAllElements();
        }
        for (int i = 0; i < this.m_wobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
            VWWorkObject wob = woData.getWob();
            if (woData.getLockedStatus() != 1 || wob == null) continue;
            VWAdminDataObjForWFGroups workflowInfo = new VWAdminDataObjForWFGroups(woData);
            this.m_vSelectedWork.addElement(workflowInfo);
        }
    }

    private void updateWork() {
        try {
            if (this.m_vErrors != null) {
                this.m_vErrors.removeAllElements();
            }
            for (int i = 0; i < this.m_vWflGroups.size(); ++i) {
                VWAdminWflGroupDataObj wflGroup = (VWAdminWflGroupDataObj)this.m_vWflGroups.elementAt(i);
                String wflGroupName = wflGroup.getName();
                VWAdminItemInList[] itemsInList = wflGroup.getSelectedObjects();
                for (int j = 0; j < this.m_vSelectedWork.size(); ++j) {
                    VWAdminDataObjForWFGroups obj = (VWAdminDataObjForWFGroups)this.m_vSelectedWork.elementAt(j);
                    VWWorkObject wob = obj.getWob();
                    VWAdminWorkObjectTableData woData = obj.getWoData();
                    try {
                        VWAdminWflGroupDataObj wflGroupData = this.isWflGroupInObject(obj, wflGroupName);
                        if (wflGroupData == null) continue;
                        VWParticipant[] participants = wflGroupData.getParticipants();
                        VWParticipant[] participantList = this.constructParticipantList(itemsInList, participants);
                        wob.setFieldValue(wflGroupName, participantList, false);
                        woData.setDirty(true);
                        continue;
                    }
                    catch (Exception ex) {
                        VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                        this.m_vErrors.addElement(errObj);
                        VWDebug.logException(ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWAdminWflGroupDataObj isWflGroupInObject(VWAdminDataObjForWFGroups obj, String wflGroupName) {
        Vector v_wflGroups = obj.getWflGroups();
        for (int j = 0; j < v_wflGroups.size(); ++j) {
            VWAdminWflGroupDataObj wflGroupInfo = (VWAdminWflGroupDataObj)v_wflGroups.elementAt(j);
            if (VWStringUtils.compareIgnoreCase(wflGroupName, wflGroupInfo.getName()) != 0) continue;
            return wflGroupInfo;
        }
        return null;
    }

    private boolean isUserInGroup(String shortName, VWParticipant[] participants) {
        if (participants == null || participants.length == 0) {
            return false;
        }
        for (int i = 0; i < participants.length; ++i) {
            if (VWStringUtils.compareIgnoreCase(shortName, participants[i].getParticipantName()) != 0) continue;
            return true;
        }
        return false;
    }

    private VWParticipant[] constructParticipantList(VWAdminItemInList[] itemsInList, VWParticipant[] participants) {
        Vector<VWParticipant> v_participants = new Vector<VWParticipant>();
        Object[] participantList = new VWParticipant[]{};
        if (itemsInList == null || itemsInList.length == 0) {
            return participantList;
        }
        for (int i = 0; i < itemsInList.length; ++i) {
            VWAdminItemInList item = itemsInList[i];
            if (item.isGrayedOut() && (!item.isGrayedOut() || !this.isUserInGroup(item.getShortName(), participants))) continue;
            VWParticipant participant = new VWParticipant();
            participant.setParticipantName(item.getShortName());
            v_participants.addElement(participant);
        }
        if (v_participants.size() > 0) {
            participantList = new VWParticipant[v_participants.size()];
            v_participants.copyInto(participantList);
        }
        return participantList;
    }

    private boolean isAnyWflGroupDefined() {
        for (int i = 0; i < this.m_vSelectedWork.size(); ++i) {
            VWAdminDataObjForWFGroups workflowInfo = (VWAdminDataObjForWFGroups)this.m_vSelectedWork.elementAt(i);
            Vector v_wflGroups = workflowInfo.getWflGroups();
            if (v_wflGroups.size() == 0) continue;
            return true;
        }
        return false;
    }

    private void selectWobs() {
        if (this.m_wobsList.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_wobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
            int rowIndex = woData.getRowIndex();
            if (!woData.isDirty() || rowIndex < 0) continue;
            this.m_listSelectionModel.addSelectionInterval(rowIndex, rowIndex);
        }
    }

    private void removeReferences() {
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.m_vWflGroups != null) {
            this.m_vWflGroups.removeAllElements();
        }
        if (this.m_vSelectedWork != null) {
            this.m_vSelectedWork.removeAllElements();
        }
        if (this.m_manageWflGroupsDlg != null) {
            this.m_manageWflGroupsDlg.removeReferences();
            this.m_manageWflGroupsDlg = null;
        }
    }
}

